Option Explicit

'Declare registry root keys constants
Const HKEY_CLASSES_ROOT  = &H80000000
Const HKEY_CURRENT_USER  = &H80000001
Const HKEY_LOCAL_MACHINE = &H80000002

'Version compare:
Const FIRST_EQUAL_SECOND          =     0
Const FIRST_LESS_THAN_SECOND      =     -1
Const FIRST_GREATER_THAN_SECOND   =     1

'Utils:
Dim fileUtils : Set fileUtils = new FileApi
Dim registryUtils : Set registryUtils = new RegistryApi
Dim systemUtils : Set systemUtils = new SystemApi

'Log settings
Const appendLogsToFile = 8              'File operation flag   
Const redirectLogToOutput = true        'Should log data shown at output window
Const redirectLogToTempFile = true      'Should log data writes to file in temprary folder
Const isDebugMode = false                'debug mode on if true. Attach and debug by VS
Const pressEnterOnFinish = true                'debug mode on if true. Attach and debug by VS

'System objects
Dim scriptFilesystem : Set scriptFilesystem = CreateObject("Scripting.FileSystemObject") 
Dim scriptShell : Set scriptShell = CreateObject("WScript.Shell")
Dim scriptApplication : Set scriptApplication = CreateObject("Shell.Application")
Dim scriptRegistry : Set scriptRegistry = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")

' nitro-cleanup.vbs /uninstallProBelow:13.23.0.428
Dim uninstallAnyVersionBelow    : uninstallAnyVersionBelow  = WScript.Arguments.Named.Item("uninstallProBelow")
Dim executeUninstallOnly        : executeUninstallOnly      = uninstallAnyVersionBelow <> ""

Main()

Sub Main
    systemUtils.ElevateUAC()

    wscript.echo(executeUninstallOnly)


    If NOT executeUninstallOnly Then
        WriteToLog "[Full Cleanup]"

        NitroUninstall()
        NitroUninstallPrinters()
        NitroDiskCleanup()
        NitroRegistryCleanup()
    Else
        WriteToLog "[Uninstall all version below " & uninstallAnyVersionBelow & "]"
        NitroUninstall()
    End if

    If pressEnterOnFinish = true Then
        WScript.Echo "Cleanup finished. Press [ENTER] to exit..."
        WScript.StdIn.ReadLine
    End If
End Sub


Sub NitroUninstall
    WriteToLog "[Uninstall Nitro products]"

    Call systemUtils.UninstallProduct("Nitro PDF Professional 7", uninstallAnyVersionBelow)  ' Pro 7 beta
    Call systemUtils.UninstallProduct("Nitro PDF Professional",   uninstallAnyVersionBelow)  ' Pro 6
    Call systemUtils.UninstallProduct("Nitro Pro 8",              uninstallAnyVersionBelow)  ' Pro 8 
    Call systemUtils.UninstallProduct("Nitro Pro 9",              uninstallAnyVersionBelow)  ' Pro 9 
    Call systemUtils.UninstallProduct("Nitro Pro 10",             uninstallAnyVersionBelow)  ' Pro 10 
    Call systemUtils.UninstallProduct("Nitro Pro",                uninstallAnyVersionBelow)  ' Pro 11, Pro 12, Pro 13
    Call systemUtils.UninstallProduct("Nitro PDF Pro",            uninstallAnyVersionBelow)  ' Pro 14
    Call systemUtils.UninstallProduct("Nitro Reader 3","")                                   ' Reader 3
    Call systemUtils.UninstallProduct("Nitro Reader 4","")                                   ' Reader 4
    Call systemUtils.UninstallProduct("Nitro PDF Reader","")                                 ' Reader 1
    Call systemUtils.UninstallProduct("Nitro PDF Reader 2","")                               ' Reader 2 beta
    Call systemUtils.UninstallProduct("Nitro Reader","")                                     ' Reader 2
    Call systemUtils.UninstallProduct("Nitro PDF DMS","")                                    ' DMS Beta        
    Call systemUtils.UninstallProduct("Nitro DMS","")                                        ' DMS
    Call systemUtils.UninstallProduct("Nitro PDF Express","")                                ' Express 1
    Call systemUtils.UninstallProduct("Nitro PDF Express","")                                ' Express 2
    Call systemUtils.UninstallProduct("Nitro OCR Expansion","")                              ' OCR Expansion

End Sub

Sub NitroUninstallPrinters()
    WriteToLog "[Uninstall Nitro Printers]"
    systemUtils.UninstallPrinters() 
End Sub


Sub NitroDiskCleanup()
    WriteToLog "[Disc Cleanup]"
     'Clean App Data
    Dim appDataFolder : appDataFolder = scriptShell.ExpandEnvironmentStrings("%appdata%")

    fileUtils.DeleteFolder(appDataFolder & "\Nitro*")
    fileUtils.DeleteFolder(appDataFolder & "\..\LocalLow\Nitro*")
    fileUtils.DeleteFolder(appDataFolder & "\..\Local\Nitro*")

    'Push Nitro folders from Program Files
    Dim programFiles : programFiles = scriptShell.ExpandEnvironmentStrings("%PROGRAMFILES%")
    Dim programFilesX86 : programFilesX86 = scriptShell.ExpandEnvironmentStrings("%PROGRAMFILES(x86)%")

    fileUtils.DeleteFolder(programFiles & "\Nitro*")
    fileUtils.DeleteFolder(programFiles & "\Common Files\Nitro*")
    fileUtils.DeleteFolder(programFilesX86 & "\Nitro*")
    fileUtils.DeleteFolder(programFilesX86 & "\Common Files\Nitro*")

    'Add Nitro data from ProgramData 
    Dim programData : programData = scriptShell.ExpandEnvironmentStrings("%ProgramData%")
    fileUtils.DeleteFolder(programData & "\Nitro*")

    'Add temp directory for cleanup
    Dim tempFolder : tempFolder = scriptShell.ExpandEnvironmentStrings("%temp%")
    fileUtils.DeleteFolder(tempFolder & "\Nitro*")
    fileUtils.DeleteFile(tempFolder & "\Nitro*") 

End Sub

'Registy cleanup
Sub NitroRegistryCleanup()
    WriteToLog "[Remove Registry Keys]"

    Call registryUtils.DeleteKeysByName(HKEY_LOCAL_MACHINE, "Software\Wow6432Node", "NITRO")
    Call registryUtils.DeleteKeysByName(HKEY_LOCAL_MACHINE, "Software", "NITRO")
    Call registryUtils.DeleteKeysByName(HKEY_CURRENT_USER, "Software", "NITRO")
    Call registryUtils.DeleteKeysByName(HKEY_CURRENT_USER, "Software\BugSplat", "NITRO")
    Call registryUtils.DeleteKeysByName(HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows NT\CurrentVersion\Print\Printers", "NITRO")
    Call registryUtils.DeleteKeysByName(HKEY_LOCAL_MACHINE, "SOFTWARE\Wow6432Node\Microsoft\Windows NT\CurrentVersion\Print\Printers", "NITRO")
    Call registryUtils.DeleteKeysByName(HKEY_LOCAL_MACHINE, "SYSTEM\CurrentControlSet\Control\Print\Printers", "NITRO")
    Call registryUtils.DeleteKeysByName(HKEY_CLASSES_ROOT, "", "NitroPDF")

    Call registryUtils.DeleteKey(HKEY_CLASSES_ROOT, "AppID\{3A7B4EA1-8CA8-4629-B09A-FB4EE0632BA8}")
    Call registryUtils.DeleteKey(HKEY_CLASSES_ROOT, "AppID\NPNitroIE.dll")
    
    Call registryUtils.DeleteKey(HKEY_CLASSES_ROOT, "TypeLib\{3422E9DB-7B00-4552-B016-6FBF93C5A2D8}")
    Call registryUtils.DeleteKey(HKEY_CLASSES_ROOT, "TypeLib\{73BA4610-4C33-4056-9141-9C3E3DF75428}")
    Call registryUtils.DeleteKey(HKEY_CLASSES_ROOT, "Wow6432Node\AppID\{3A7B4EA1-8CA8-4629-B09A-FB4EE0632BA8}")
    Call registryUtils.DeleteKey(HKEY_CLASSES_ROOT, "Wow6432Node\AppID\NPNitroIE.dll")
    Call registryUtils.DeleteKey(HKEY_CLASSES_ROOT, "Wow6432Node\TypeLib\{3422E9DB-7B00-4552-B016-6FBF93C5A2D8}")
    Call registryUtils.DeleteKey(HKEY_CLASSES_ROOT, "Wow6432Node\TypeLib\{73BA4610-4C33-4056-9141-9C3E3DF75428}")
    
    Call registryUtils.DeleteKey(HKEY_CURRENT_USER, "Software\Microsoft\Internet Explorer\InternetRegistry\REGISTRY\USER\S-1-5-21-135482287-46112240-147394707-1265\Software\Nitro")

    WriteToLog "[Remove Registry Values]"
    Call registryUtils.DeleteValuesByName(HKEY_CURRENT_USER, "Printers\Settings", "NITRO")
    Call registryUtils.DeleteValuesByName(HKEY_CURRENT_USER, "Software\Microsoft\Windows NT\CurrentVersion\Devices", "NITRO")
    Call registryUtils.DeleteValuesByName(HKEY_CURRENT_USER, "Software\Microsoft\Windows NT\CurrentVersion\PrinterPorts", "NITRO")    
    Call registryUtils.DeleteValuesByName(HKEY_CURRENT_USER, "Environment", "NITRO")    


    'Office template for delete values    
    Dim nitroPDFProfessionalCollection : Set nitroPDFProfessionalCollection = CreateObject("System.Collections.ArrayList")
    Call nitroPDFProfessionalCollection.Add("Software\Microsoft\Office\{0}\Excel\AddInLoadTimes")    
    Call nitroPDFProfessionalCollection.Add("Software\Microsoft\Office\{0}\Outlook\AddInLoadTimes")    
    Call nitroPDFProfessionalCollection.Add("Software\Microsoft\Office\{0}\Outlook\Resiliency\DoNotDisableAddinList")    
    Call nitroPDFProfessionalCollection.Add("Software\Microsoft\Office\{0}\Outlook\Resiliency\NotificationReminderAddinData")    
    Call nitroPDFProfessionalCollection.Add("Software\Microsoft\Office\{0}\PowerPoint\AddInLoadTimes")    
    Call nitroPDFProfessionalCollection.Add("Software\Microsoft\Office\{0}\Word\AddInLoadTimes")    

    'Office template for delete keys    
    Dim msOfficeAddinCollection : Set msOfficeAddinCollection = CreateObject("System.Collections.ArrayList")
    Call msOfficeAddinCollection.Add("Software\Microsoft\Office\{0}\Outlook\Addins\NitroPDFProfessional.MSOfficeAddin10")
    Call msOfficeAddinCollection.Add("Software\Microsoft\Office\{0}\Outlook\Addins\NitroPDFProfessional.MSOfficeAddin11}")
    Call msOfficeAddinCollection.Add("Software\Microsoft\Office\{0}\Outlook\Addins\NitroPDFProfessional.MSOfficeAddin12")
    Call msOfficeAddinCollection.Add("Software\Microsoft\Office\{0}\Outlook\Addins\NitroPDFProfessional.MSOfficeAddin13")
    Call msOfficeAddinCollection.Add("Software\Microsoft\Office\{0}\Outlook\Addins\NitroPDFProfessional.MSOfficeAddin14")

    Dim textOutputBuffer

    Dim officeSubKeyCollection : officeSubKeyCollection = registryUtils.GetSubkeyCollection(HKEY_CURRENT_USER, "Software\Microsoft\Office")

    'Enumerate all office versions
    Dim officeVersionKey
    For Each officeVersionKey In officeSubKeyCollection 

        'If first symbol of subkey is a number, this is an office version
        Dim officeCheckVersion : officeCheckVersion = Left(officeVersionKey, 1)
        If IsNumeric(officeCheckVersion) Then

            Dim nitroPDFProfessional
            For Each nitroPDFProfessional In nitroPDFProfessionalCollection 
                textOutputBuffer = Replace(nitroPDFProfessional, "{0}", officeVersionKey)
                Call registryUtils.DeleteValuesByName(HKEY_CURRENT_USER, textOutputBuffer, "NitroPDFProfessional")    
            Next

            Dim msOfficeAddin
            For Each msOfficeAddin In msOfficeAddinCollection 
                textOutputBuffer = Replace(msOfficeAddin, "{0}", officeVersionKey)
                Call registryUtils.DeleteKey(HKEY_CURRENT_USER, msOfficeAddin)
            Next

        End If 
    Next 

End Sub


class SystemApi

    'Second script run: under admin rights we execute cleanup code.
    Sub ElevateUAC
        Dim bElevate: bElevate = False
        If WScript.Arguments.Count > 0 Then If WScript.Arguments(WScript.Arguments.Count-1) <> "|" then bElevate = True
        
        if bElevate Or WScript.Arguments.Count = 0 Then 
            'First script run: we call ElevateUAC which re-execute our script under admin rights. 
            Dim sParms
            sParms = " |"
            If WScript.Arguments.Count > 0 Then
               'Repack params
                dim i
                For i = WScript.Arguments.Count-1 To 0 Step -1
                    sParms = " " & WScript.Arguments(i) & sParms
                Next
            End If

            'Check debug mode
            Dim commandLine 
            if isDebugMode = false Then
                commandLine = """" & WScript.ScriptFullName & """" & sParms 'Release don't remove
            Else 
                commandLine = "/x " & """" & WScript.ScriptFullName & """" & sParms 'Debug don't remove
            End If

            'execute under admin rights
            scriptApplication.ShellExecute "cscript.exe", commandLine, , "runas", 1
            WScript.Quit
        End If
    End Sub

    Function Max(x, y)
        If x > y Then Max = CInt(x) Else Max = CInt(y)
    End Function

    Function compareFileVersion(firstVersion , secondVersion)
        dim intResult           : intResult             = FIRST_EQUAL_SECOND
        dim firstVersionArray   : firstVersionArray     = Split(firstVersion, ".")
        dim secondVersionArray  : secondVersionArray    = Split(secondVersion, ".")
        Dim lastIndex           : lastIndex             = Max(UBound(firstVersionArray), UBound(secondVersionArray))
    
        Dim i
        For i = 0 To lastIndex
            Dim firstValue  :   firstValue  = 0
            Dim secondValue :   secondValue = 0
            if  i <= ubound(firstVersionArray) then firstValue = CInt(firstVersionArray(i)) 
            if  i <= ubound(secondVersionArray) then secondValue = CInt(secondVersionArray(i)) 
            
            If firstValue > secondValue Then
                intResult = FIRST_GREATER_THAN_SECOND
            ElseIf firstValue < secondValue Then
                intResult = FIRST_LESS_THAN_SECOND
            End If
            If intResult <> FIRST_EQUAL_SECOND Then Exit For
        Next
        compareFileVersion = intResult
    End Function

    'Try uninstall product with using standard msiexec
    Public Function UninstallProduct(productName, uninstallVersionBelow) 
        If uninstallVersionBelow = "" Then
            WriteToLog "  [Uninstall] - " & productName
        Else
            WriteToLog "  [Uninstall] - " & productName & " if version below " & uninstallVersionBelow
        End if

        Dim productCode, property, installer, BootstrapperGuid
        
        Set installer = Wscript.CreateObject("WindowsInstaller.Installer")

        'Find by name installed product
        For Each productCode In installer.Products
            'WScript.Echo "Product Name " & productName & "Product Code " & productCode &" : " & LCase(installer.ProductInfo(productCode, "ProductName"))
            If InStr(1, LCase(installer.ProductInfo(productCode, "ProductName")), LCase(productName)) Then Exit For
        Next

        'if we found it, try uninstall it
        If Not IsEmpty(productCode) Then
            
            Dim productVersion  : productVersion    = installer.ProductInfo(productCode, "VersionString")
            Dim uninstall       : uninstall         = uninstallVersionBelow = "" OR compareFileVersion(productVersion, uninstallVersionBelow) = FIRST_LESS_THAN_SECOND

            IF uninstall = True Then
                Dim  QuietUninstallString
                if productName="Nitro Pro 9" Or productName="Nitro Pro 10" Or productName="Nitro Pro" Or productName="Nitro PDF Pro" then
                    
                    'Try to find the bootstrapper executable. For retail we un-install using this rather than msiexec.
                    WriteToLog("Try to find bootstrapper GUID in SOFTWARE\Classes\Installer\Dependencies\"&productCode&"\Dependents")
                    BootstrapperGuid = registryUtils.GetKey(HKEY_LOCAL_MACHINE, "SOFTWARE\Classes\Installer\Dependencies\"&productCode&"\Dependents", "")

                    If IsEmpty(BootstrapperGuid) Or BootstrapperGuid="" Then
                        WriteToLog("Try to find bootstrapper GUID in SOFTWARE\Wow6432Node\Classes\Installer\Dependencies\"&productCode&"\Dependents")
                        BootstrapperGuid = registryUtils.GetKey(HKEY_LOCAL_MACHINE, "SOFTWARE\Wow6432Node\Classes\Installer\Dependencies\"&productCode&"\Dependents", "")
                    End If
                    
                    if Not IsEmpty(BootstrapperGuid) And Not BootstrapperGuid="" Then
                        'The bootstrapper was used to install. Now look for the "QuietUninstall" command that will uninstall without showing a UI
                        WriteToLog(productName&" Bootstrapper GUID: "&BootstrapperGuid)
                        QuietUninstallString = registryUtils.GetValue(HKEY_LOCAL_MACHINE, "SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\"&BootstrapperGuid, "QuietUninstallString", "")
                        
                        If IsEmpty(QuietUninstallString) Or QuietUninstallString="" Then
                            QuietUninstallString = registryUtils.GetValue(HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\"&BootstrapperGuid, "QuietUninstallString", "")
                        End If
                        
                        If Not IsEmpty(QuietUninstallString) Then
                            WriteToLog("Running command: "&QuietUninstallString)
                            scriptShell.Run QuietUninstallString, , True
                        else
                            'Could not find a QuiteUninstall command. Let's just use msiexec as a last resort
                            WriteToLog("msiexec /x " & productCode & " /qb")
                            scriptShell.Run "msiexec /x " & productCode & " /qb", , TRUE
                        End If
                    else
                        WriteToLog("msiexec /x " & productCode & " /qb")
                        scriptShell.Run "msiexec /x " & productCode & " /qb", , TRUE
                    End If
                else
                    WriteToLog("msiexec /x " & productCode & " /qb")
                    scriptShell.Run "msiexec /x " & productCode & " /qb", , TRUE
                End If
            Else
                    WriteToLog("        Skip uninstalling" & productCode & " , version " & productVersion)
            End if
            
        End If
    End Function 

    'Uninstall printers 
    Sub UninstallPrinters()

        'Delete printer by OS
        WriteToLog "[Uninstall printers by OS]"
        Dim scriptNetwork : Set scriptNetwork = CreateObject("WScript.Network")

        Dim wmiService 
        Set wmiService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & scriptNetwork.ComputerName & "\root\cimv2")
        
        Dim installedPrinters 
        Set installedPrinters = wmiService.ExecQuery("Select * from Win32_Printer")

        if IsArray(installedPrinters) Then
            'Look for installed printer
            Dim printer
            For Each printer in installedPrinters
                If InStr(UCase(printer.Name), "NITRO") > 0 Then
                    'If we found it try to delete it
                    WriteToLog "  [Delete printer] - " & printer.Name 
                    printer.Delete_
                End If
            Next
        End If
        
        'Delete all printers files 
        WriteToLog "[Delete all printers files ]"

        Dim windowsFolder
        windowsFolder = scriptShell.ExpandEnvironmentStrings("%windir%")

        Dim printerFoldersCollection
        printerFoldersCollection = Array(windowsFolder & "\System32\spool\drivers\x64\", windowsFolder & "\System32\spool\drivers\x64\3\" ,windowsFolder & "\System32\spool\drivers\w32x86\", windowsFolder & "\System32\spool\drivers\w32x86\3\", windowsFolder & "\System32\")

        Dim printerFiles
        printerFiles = Array("nitroui*.hlp", "nitrographics*.dll", "nitroui*.dll", "nitrolocalui*.dll", "nitrolocalmon*.dll" , "NxPrinterMonitor*.dll", "NxPrinterMonitorUI*.dll", "NxPdfCreator.ini", "NxPdfCreator.ppd",  "NxPdfUI*.dll", "NxPdfCreator.BPD")

        'Stop spooler to unlock files
        WriteToLog "  [Try to stop spooler]"
        scriptShell.Run "NET STOP spooler", 1, false

        'Wait 5 sceonds
        WriteToLog "  [Wait 5 seconds]"
        WScript.Sleep(5000)

        'Try to remove files
        WriteToLog "  [Printer files remove]"
        Dim filesSet, printerFolder, printerFile
        For Each printerFolder in printerFoldersCollection
            For Each printerFile in printerFiles
                fileUtils.DeleteFile(printerFolder & printerFile) 
            Next
        Next

        'Start spooler again
        WriteToLog "  [Try to start spooler]"
        scriptShell.Run "NET START spooler", 1, false
    End Sub
End class

Class FileApi
    Public Sub DeleteFolder(pathToFolder)
        On Error Resume Next

        'Try to delete with using FileSystemObject
        Dim scriptFilesystem : Set scriptFilesystem = CreateObject("Scripting.FileSystemObject") 
        scriptFilesystem.DeleteFolder pathToFolder, true

        'If we get access denied, try to delete with using cmd.exe
        If Err.Number = &H46 then    
            WriteToLog "> Error: Access denied while removing directory - " & pathToFolder
            WriteToLog "Try to remove file throw cmd command"
            scriptShell.Exec("cmd /c rmdir /q /s """ & pathToFolder & """") 
        End If

        If Err.Number = &H0 Then
            WriteToLog "  [Remove folder(s)] - " & pathToFolder
        End If

    End Sub

    Public Sub DeleteFile(pathToFile)
        On Error Resume Next

        'Try to delete with using FileSystemObject
        Dim scriptFilesystem : Set scriptFilesystem = CreateObject("Scripting.FileSystemObject") 
        scriptFilesystem.DeleteFile pathToFile, true

        'If we get access dinied, try to delete with using cmd.exe
        If Err.Number = &H46 then    
            WriteToLog "> Error: Can not remove file. Access denied - " & pathToFile
            WriteToLog "Try to remove file throw cmd command"
            scriptShell.Exec("cmd /c del /q /s """ & pathToFile & """") 
        End If

        If Err.Number = &H0 Then
            WriteToLog "  [Remove file(s)] - " & pathToFile
        End If
    End Sub

End Class


Class RegistryApi

    'Gets registry key 
    Public function GetSubkeyCollection (hKey, keyPath)
        On Error Resume Next

        Dim subkeysCollection
        Call scriptRegistry.EnumKey (hKey, keyPath, subkeysCollection)
        GetSubkeyCollection = subkeysCollection

    end function


    'Gets registry key 
    Public function GetKey (hKey, strRegistryKey, strDefault )
        On Error Resume Next

        Dim value
        Dim sPath, aSub, sKey
        scriptRegistry.EnumKey hKey, strRegistryKey, aSub
        If IsArray( aSub ) Then
            For Each sKey In aSub
                value=sKey
            Next
            GetKey=value
        else
            GetKey= strDefault
        end if
    end function

    'Gets registry key value
    Public function GetValue (hKey, strRegKey, valueName, strDefault )
        On Error Resume Next

        Dim  arrValueNames, arrTypes, sKey, strValueName, strValue
        scriptRegistry.EnumValues hKey, strRegKey, arrValueNames, arrTypes
        
        If IsArray( arrValueNames ) Then
            For Each sKey In arrValueNames
                strValueName = sKey
                scriptRegistry.GetStringValue hKey, strRegKey, strValueName, strValue
                if strValueName=valueName then
                    GetValue=strValue
                End If    
            Next
        else
            GetValue = strDefault
        end if
    end function


    Public Sub DeleteValue(rootKey, keydeleteFrom, value)
        On Error Resume Next

        Dim deleteKeyValueResult : deleteKeyValueResult = scriptRegistry.DeleteValue (rootKey, keydeleteFrom, value)

        If ((deleteKeyValueResult = 0) And (Err.Number = &H0)) Then
            WriteToLog "  [Key registry value removed] - " & value & " from - " & keydeleteFrom
        Else
            Dim registryKeyStr : registryKeyStr = HKeyToString(rootKey)

            WriteToLog "> Error: Registry value was not remove by VBS. Error occured. " & registryKeyStr & "\" & keyPathToDelete
            WriteToLog "Try to delete value throw the cmd commands"
            scriptShell.Exec("REG DELETE """& registryKeyStr &"\"& keydeleteFrom &""" /f /v """& value &"""" )
        End If
    End Sub

    Public Sub DeleteKey(hKey, keyPathToDelete)
        On Error Resume Next

        Dim deleteKeyResult : deleteKeyResult = DeleteKeyRecursive (hKey, keyPathToDelete)

        If ((deleteKeyResult = 0) And (Err.Number = &H0)) Then
            WriteToLog "  [Registry key removed] - " & keyPathToDelete
        Else
            Dim registryKeyStr
            registryKeyStr = HKeyToString(hKey)

            WriteToLog "> Error: Can not remove registry by VBS. Error occured. " & registryKeyStr & "\" & keyPathToDelete
            WriteToLog "Try to delete key with using cmd commands"
            scriptShell.Exec("REG DELETE """& registryKeyStr &"\"& keyPathToDelete &""" /f " )
        End If
    End Sub

    'Registry subkey cleanup: At "keyParent" finds subkey which contains "subkeyToDelete" and remove it.
    Public Sub DeleteKeysByName(registryKey, keyParent,  subkeyToDelete)

        If subkeyToDelete <> "" Then
            Dim keysCollection
            scriptRegistry.EnumKey registryKey, keyParent, keysCollection

            If IsArray( keysCollection ) Then

                Dim key
                For Each key in keysCollection
                    If InStr(UCase(key), UCase(subkeyToDelete)) > 0 Then
                        Call DeleteKey(registryKey, keyParent & "\" & key)
                    End If
                Next 
            End If
        End If
    End Sub

    'Registry value cleanup: At "keydeleteFrom" finds values which contains "valueNameToDelete" and remove it.
    Public Sub DeleteValuesByName(registryKey, keydeleteFrom, valueNameToDelete)

        If valueNameToDelete <> "" Then

            Dim keyValuesCollection
            scriptRegistry.EnumValues registryKey, keyDeleteFrom, keyValuesCollection

            If IsArray( keyValuesCollection ) Then

                Dim keyValue
                For Each keyValue in keyValuesCollection
                    If InStr(UCase(keyValue), UCase(valueNameToDelete)) > 0 Then
                        Call DeleteValue(registryKey, keydeleteFrom, keyValue)
                    End IF
                Next 
            End If
        End If
    End Sub

    Private Function DeleteKeyRecursive(hKey, keyPathToDelete)
        Dim subkeysCollection
        Call scriptRegistry.EnumKey (hKey, keyPathToDelete, subkeysCollection)

        Dim operationResult : operationResult = 0 
        If IsArray(subkeysCollection) Then 
            Dim subkey
            For Each subkey In subkeysCollection 
                 operationResult = DeleteKeyRecursive(hKey, keyPathToDelete & "\" & subkey)
            Next 
        End If 

        If operationResult = 0 Then
            DeleteKeyRecursive = scriptRegistry.DeleteKey(hKey, keyPathToDelete)
        Else
            DeleteKeyRecursive = operationResult
        End If

    End Function

    Private function HKeyToString (hKey)
        HKeyToString = "HKCU"
        If hKey = HKEY_LOCAL_MACHINE Then 
            HKeyToString = "HKLM"
        ElseIf hKey = HKEY_CLASSES_ROOT Then
            HKeyToString = "HKCR"
        End If
    End Function

End Class


 
Sub WriteToLog(strLogMessage)
     
    dim strLogFileName, strLogEntryTime, objLogFileTransaction
     
    strLogEntryTime = NOW

    Dim logToOutput
    logToOutput = "[ " & strLogEntryTime &" ] - " & strLogMessage

    If redirectLogToTempFile = true Then
        Dim scriptdir
        scriptdir = scriptFilesystem.GetParentFolderName(WScript.ScriptFullName)

        strLogFileName = scriptdir&"\nitro-cleanup-tool.log"
        if scriptFilesystem.FileExists(strLogFileName) Then
            Set objLogFileTransaction = scriptFilesystem.OpenTextFile(strLogFileName,appendLogsToFile)
        Else
            Set objLogFileTransaction = scriptFilesystem.CreateTextFile(strLogFileName)
        End if
        
        objLogFileTransaction.WriteLine logToOutput 
        objLogFileTransaction.Close
    End If

    If redirectLogToOutput = true Then 
        ' WScript.StdOut.WriteLine logToOutput
        ' WScript.StdOut.WriteLine ""
        Wscript.Echo logToOutput
    End If

End Sub
